//Version 1.5

// RoverCom.cpp : Defines the entry point for the application.


#include "stdafx.h"
#include "RoverCom.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include "comm.h"
#include "serial.h"
#include "tcpip.h"
#include  <Afx.h>

#define MOTOR 0
#define NECK  1
#define HEAD  2

#define MAX_LOADSTRING 100
#define CAMERATIMEOUT  10  //this times 50 ms equals total Camera timeout
#define STEMTIMEOUT    4   //this times 50 ms equals total Stem timeout
#define COM comTest


// Global Variables:
HINSTANCE			hInst;					// The current instance
HWND				hwndCB;					// The command bar handle
static SHACTIVATEINFO s_sai;

//Globals for the timeouts
SYSTEMTIME systime;

//Globals for the timeouts

//  these will be in seconds, but contain minutes + seconds //
int headLastSec		=0;
int neckLastSec		=0;
int pidLastSec		=0; // this is really the motor spinning
int motorLastSec	=0;
int neckTimeout = 2;	// neck times power off after n seconds //
int headTimeout = 2;	// head times power off after n seconds //
int motorTimeout= 6;	// motor times power off after 5 seconds //
int pidTimeout	= 5;	// PID times power off after 5 seconds //
int cmdCP = 127;	// last commanded pan position
int cmdCT = 127;	// last commanded tilt position

//Globals for the timeouts

// Globals for tracking
int trackState	= 0;
int cycCount	= 0;
unsigned char trackx,tracky, trackwidth, trackheight, trackpix, trackconf;
unsigned char trackCP, trackCT; // globals keeping track of servo positions
char bufone[8], buftwo[8];
// Globals for tracking



// Global Variables for Single Thread
serialPort *comTest=NULL;	// Serial port on iPaq
TCPIP* tcpsocket=NULL;		// this will be instance of tcp connection
TCPIP* dfsocket	=NULL;		// socket for sending back dumpframe data from CMUcam
TCPIP* trsocket	=NULL;		//socket for listening to Active Tracking commands

int camCom			= 1;		//serial port switcher; 1 means COM1 (camera); 0 means COM2 (rover) 
bool PIDoff			=true;
bool motorOn		=false;
bool neckOn			=false;
bool headOn			=false;
bool trackOn		=false;
bool tracknp		=false;
bool tracknt		=false;
bool tracknpnt		=false;
bool terminateNow	=false;

// Global Variables for Single Thread



// Forward declarations of functions included in this code module:

DWORD KillThread(LPVOID lpvoid);
void switchCamCom();
void switchRoverCom();

void CameraDeal(char* parsebuf,int parsecount);
void returnCamResponse();
void RoverDeal(char* sockData, int bufLen);
void returnRoverResponse();
void StemDeal(char* parsebuf);
void returnStemResponse();
void DumpFrameDeal();
void colourTrack(char* parsebuf);
void windowTrack();
void stopTrack();
void parseNow(char* buf, int len);
void sendPacket(char* buf, int len, TCPIP* outputsocket);

unsigned char checksum(char* sockData, int length);
int justSecs(int minutes, int secs);
void handleTimeouts(); // deal with servo and motor timeouts to save battery power
void handleTracking(); // deal with parsing tracking and call moveHead to actually servo... //
void headMove(int x, int y); // will move head to servo-visually center tracked object //

// Forward declarations of functions included in this code module:


// BrainStem functions 

void initRobot();
void killRobot();
bool initServo(int servoID);
void setServo(char angle, int servoID);
void setServoRange(int servoID);
void killServo(int servoID);
bool turnPIDon();
void setVel(char speed);
void killMotor();
void setMotorConstants();
void ask_rangeRead();
bool get_rangeRead(char &range);
bool getPWM(char* pwm);

// BrainStem functions

ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
HWND				CreateRpCommandBar(HWND);


int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	//MSG msg;
	//HACCEL hAccelTable;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	//open our serial port//
	
	
	comTest=new serialPort(_T("COM1:")); 

	if (!comTest->valid) {
		// exit the program completely!
		delete comTest;
		return -1;
	}

	//terminateNow = false;
	DWORD ThreadID;
	HANDLE hkillThread = CreateThread(NULL,0,KillThread,0,0,&ThreadID);
	if (hkillThread)
	{
      CloseHandle (hkillThread);
	}
    else
	{
		MessageBox (0, TEXT("Unable to create iPaq KillThread"), 
                TEXT("Error"), MB_OK);
	}

	
	switchRoverCom(); // start switched to Rover //
	Sleep(50);
	switchRoverCom();
	camCom = 0;
	initRobot(); // set full servo range, disable servoes and motors, set PID constants
	//initRobot(); // try again for superstition
	PIDoff = true; headOn = false; neckOn = false; motorOn = false;

	
	//listen and accept incoming socket connection //
	tcpsocket	=	new TCPIP(5000);
	dfsocket	=	new TCPIP(5001);
	trsocket	=	new TCPIP(5002);
	
	
	while (!terminateNow) {
		if (tcpsocket->connected()) {
			break;
		}
		Sleep(200);
		}
		
		while (!terminateNow) {
			if (dfsocket->connected()) {
				break;
			}
			Sleep(200);
		}

		while (!terminateNow) {
			if (trsocket->connected()) {
				break;
			}
			Sleep(200);
		}
	
	int receivelen;
	char* sockData;
	char* dummy;

	
	int parsecount;
	char parsebuf[200]; 
	int state;  // 0 - reading packet
				// 1 - read one 255
			    
	state = 0; parsecount = 0; 
	
	
	for(int i=0; i<8;i++)
	{
		bufone[i]=0;
		buftwo[i]=0;
	}
      
	while (!terminateNow) {
		// these two calls enable checking to see if socket is broken so that
		// blocking accept can be initiated for new connections
		
		dfsocket->recieveData(dummy);
		trsocket->recieveData(dummy);
	
		receivelen = tcpsocket->recieveData(sockData); //nonblocking receive ****
				
		if (!dfsocket->connected() || !trsocket->connected() || !tcpsocket->connected()) {
			// one or more sockets is down. quit the whole program! //
			terminateNow = true;    
			break;
		}
		
		if (receivelen > 0) // we have 1 or more bytes to read
		{
			
			for (int i=0 ; i < receivelen; i++) {
				if (state == 0) {
					if (((unsigned char)sockData[i]) == 255) {
						state = 1;
					} else {
						parsebuf[parsecount] = sockData[i];
						parsecount++;
					}
				} else { //now we assume we just saw a 255...in state 1
					if (((unsigned char) sockData[i]) == 255) {
						state = 0;
						parsebuf[parsecount] = sockData[i];
						parsecount++;
					} else { // it is not a 255...
						if (((unsigned char)sockData[i]) == 55) {
							parseNow(parsebuf, parsecount);
							state = 0; parsecount=0; 
						} else if (((unsigned char) sockData[i]) == 56) {
							state=0; parsecount=0;
						} else if (((unsigned char) sockData[i]) == 54) {
							terminateNow = true;
							break;
						} else {
							state = 0; parsecount = 0;
						}
					} // endelse
				} // endelse state was 1
			} // end for..
		}//end of if(data to read)...	
		
	
		else
		{	
			if(trackOn || tracknp || tracknt || tracknpnt) handleTracking();
			if(!trackOn && !tracknp && !tracknt) handleTimeouts();
			
			
			
		} // endelse
	
		// no matter what ,each cycle, if we're tracking, execute a tracking loop //
		
	} // end while (true) //

			

	//quit program now, close com port so program can run again!//

	killRobot();
	delete comTest;
	if (dfsocket->connected())
		dfsocket->closeConnection();
	if (trsocket->connected())
		trsocket->closeConnection();
	if (tcpsocket->connected())
		tcpsocket->closeConnection();
	return 0;
}//main() Win Function


DWORD KillThread(LPVOID lpvoid)
{
	
	MessageBox(0, TEXT("Press OK to kill TrikePaq"), TEXT("TrikePaq"), MB_OK);
	terminateNow=true;
	return 0;
}



// single-threaded parse of the buffer followed by doing whatever
// comm is necessary and sending it back to Master and only then returning
// control
// sockData is everything between 255 and 55
void parseNow(char *sockData, int bufLen) {
	int packetType;
	unsigned char ckSum;
	char returnPack[200];

	ckSum = (unsigned char)(sockData[bufLen-1]);
    packetType=sockData[0];
    if (ckSum != checksum(sockData,bufLen-1)) {
		// send error packet.datas: 255, 56, 1, 1, 255, 55
		returnPack[0] = 1;
		sendPacket(returnPack, 1,tcpsocket);
		return;
	}
	// we know we have a valid packet now!            
			          
    switch(packetType)
       {
            
			case 80 : //Packet to Stem via iPaq
				RoverDeal(sockData, bufLen); // standard way of communicating with brainstem 
                break;
			case 67	: //Camera packet
				CameraDeal(sockData, bufLen); // standard way of communicating with camera
				break;
			case 66:
				StemDeal(sockData); // sending raw data to the brainstem
				break;
			case 68:
				DumpFrameDeal(); // takes care of capturing frame and sending to user (dumpframe port)
				break;
			case 87:
				trackOn = true;
				windowTrack(); // use TW at CMUcam side to track an object, streaming mode
				break;
			case 89:
				// TW with no pan
				tracknp = true;
				windowTrack(); 
				break;
			case 88:
				// TW with no tilt
				tracknt = true;
				windowTrack(); 
				break;
			case 84:
				trackOn =true;
				colourTrack(sockData); // use TC on CMUcam with supplied parameters, streaming mode //
				break;			
			case 86:
				//TC with no pan
				tracknp=true;
				colourTrack(sockData); 
				break;
			case 85:
				 //TC with no tilt
				tracknt=true;
				colourTrack(sockData); 
				break;
			case 78:
				stopTrack(); // stop tracking. 
				break;
	
			case 65:
				//TC with no pan,no tilt
				tracknpnt=true;
				colourTrack(sockData); 
				break;

			case 90:
				//TW with no pan,no tilt
				tracknpnt=true;
				windowTrack(); 
				break;

			default:
				returnPack[0] = 2; // this is an Unknown Packet error //
				sendPacket(returnPack, 1, tcpsocket);
	   } // end switch

} // end parseNow() 


void handleTracking() {
	char Byte;
	char abuf[8]; 
	unsigned char bufbyte;
	bool sent = false;
	// process byte only if we read one //
	// we check to see if router is set right. if not switch it.
	if (camCom == 0) {
		switchCamCom(); camCom = 1; trackState=0; // stream was interrupted //
		// at this point flush buffer to ensure we are recent
		comTest->EmptyInputBuffer();
	}
	if(comTest->readByte(Byte)) {
			bufbyte = (unsigned char)Byte;
			if(bufbyte==255) {
				trackState=1;
			} else if(trackState==1) {
				trackState=2;
			} else if(trackState==2) {					
				trackState=3;
				trackx=bufbyte;					
			} else if(trackState==3) {
				trackState=4;
				tracky=bufbyte;
			} else if(trackState==4) {
				trackState=5;
				trackwidth=bufbyte;
			} else if(trackState==5) {
				trackState=6;
				trackheight=bufbyte;
			} else if(trackState==6) {
				trackState=7;
				trackwidth = bufbyte - trackwidth;
			} else if(trackState==7) {
				trackState=8;
				trackheight= bufbyte - trackheight;
			} else if(trackState==8) {
				trackState=9;
				trackpix = bufbyte;
			} else if(trackState==9) {
				trackState=0;
				trackconf = bufbyte;
				if (trackconf>5) headMove(trackx,tracky);
				
						
				cycCount++; cycCount = cycCount%3; // send back a third of the packets //	
				
				
			
				if(cycCount == 0) // Once every 3 cycles send Cam stats to Java side //
				{	
					abuf[0]=trackCP; abuf[1]=trackCT; abuf[2]=trackx; abuf[3]=tracky; abuf[4]=trackwidth;
					abuf[5]=trackheight; abuf[6]=trackpix; abuf[7]=trackconf;
					sent = false;
					
					if( abuf[7] > 0) 
					{
						sendPacket(abuf,8,trsocket);
						sent =true;
					}
					else
					{
						
						if(buftwo[7]>0)
						{
							sendPacket(buftwo,8,trsocket);
							sent = true;
						}
						else if(bufone[7]>0)
						{
							sendPacket(bufone,8,trsocket);
							sent = true;
						}
												
					}

					if(!sent) sendPacket(abuf,8,trsocket);
					
					
				} //end if on sending Cam stats to Java side

				else if(cycCount == 1) 
				{
					bufone[0]=trackCP; bufone[1]=trackCT; bufone[2]=trackx; bufone[3]=tracky; bufone[4]=trackwidth;
					bufone[5]=trackheight; bufone[6]=trackpix; bufone[7]=trackconf;
				}
				else if(cycCount == 2) 
				{
					buftwo[0]=trackCP; buftwo[1]=trackCT; buftwo[2]=trackx; buftwo[3]=tracky; buftwo[4]=trackwidth;
					buftwo[5]=trackheight; buftwo[6]=trackpix; buftwo[7]=trackconf;
				}
			
			}//if(trackstate ==9)

	}//if(comTest)
	
} // handleTracking()

// headMove servoes head.
void headMove(int x, int y)
{
switchRoverCom();  switchRoverCom(); 
camCom = 0;

if(trackOn || tracknt)
{
	if (x == 0) {  }// do nothing 
	else if (x > 60) trackCP -=8; //3
	else if (x > 47) trackCP -=4; // 2
	else if (x < 20) trackCP +=8; // 3
	else if (x < 33) trackCP +=4; // 2
	
	if (trackCP < 10) trackCP = 10;
	if (trackCP > 245)trackCP = 245;


}

if(trackOn || tracknp)
{
	if (y == 0) { }
	else if (y > 92) trackCT += 6;
	else if (y > 85) trackCT += 4;
	else if (y < 52) trackCT -= 6;
	else if (y < 59) trackCT -= 4;
	if (trackCT < 15) trackCT = 15;
	if (trackCT > 240)trackCT = 240;

}


// if servoes are off initialize them //
if (!headOn) {	initServo(HEAD); Sleep(20); initServo(HEAD); headOn = true; }
if (!neckOn) {  initServo(NECK); Sleep(20); initServo(NECK); neckOn = true; }
		
		  
// send commands to the Stem and update timeout timers //
if (trackOn || tracknt) setServo(trackCP, NECK);
GetSystemTime(&systime);
neckLastSec=justSecs(systime.wMinute,systime.wSecond);
headLastSec = justSecs(systime.wMinute, systime.wSecond);
Sleep(10);
if(trackOn || tracknp) setServo(trackCT, HEAD); 

} // headMove() 
	


// take each 255 in the packet and double it
int duplex255(char *outBuf, char *inBuf, int len) {
	for (int i=0, int j=0; i<len; i++, j++) {
		outBuf[j] = inBuf[i];
		if (((unsigned char)inBuf[i]) == 255) {
			outBuf[j+1] = 255;
			j++;
		}		
	} // for
return j;
} // duplex255

// wraps message in '\255'\'56' at beginning and
// '\255' '\55' at end and also inserts checksum
void sendPacket(char *rawPack, int rawLen, TCPIP *outputsocket) {
	char outBuf[250];
	char duplexedBuf[250];
	int duplexedlen;
	char rawPlusCheckBuf[250];
	// copy the buffer first, then add the checksum on the end
	for (int i=0; i<rawLen; i++) rawPlusCheckBuf[i] = rawPack[i];
	rawPlusCheckBuf[rawLen] = checksum(rawPack, rawLen);

	// duplex the damn thing
	duplexedlen = duplex255(duplexedBuf, rawPlusCheckBuf, rawLen+1);

	outBuf[0] = 255;
	outBuf[1] = 56;
	for (i=0; i<duplexedlen; i++) {
		outBuf[i+2] = duplexedBuf[i];
	}
	outBuf[duplexedlen + 2] = 255;
	outBuf[duplexedlen + 3] = 55;
	outputsocket->sendData2(outBuf, duplexedlen + 4);
} // sendPacket()


// sends control code to switch to the rover, on the second Daughter Com
// NOTE: if the camera was on, then it receives the '\''2' before the
// switch occurs. So you have to start next command to camera with a \r
// to generate a NCK and then allow your actual command through! tricky.
void switchRoverCom()
{
	comTest->writeByte('\\');
	comTest->writeByte('2');
	Sleep(10);
	
	
} // switchRoverCom()

// sends control code to switch to the camera, on the first Daughter Com
void switchCamCom()
{
	comTest->writeByte('\\');
	comTest->writeByte('1');
	Sleep(10);
} // switchCamCom()




/*************************************************************************************************/
/*************************************************************************************************/

// parsebuf is EVERYTHING except 255 56 (first two bytes of a valid packet)
// we think it also does not have the end packet sequence (255 55)...
void CameraDeal(char* parsebuf,int parsecount)
{
		int cameraCmdLength;

		// camera command. send it!
			if (camCom == 0) {
				switchCamCom(); camCom = 1;
				// since we just switched back to camera, it has a '\''2'
				// sitting there. Generate a \r and then clean buffer to
				// rid us of it.
				comTest->writeByte('\r');
				Sleep(50); // a waste of time, but safe for now //
				comTest->EmptyInputBuffer();
			} else {
				comTest->EmptyInputBuffer(); // for safety and slowness, always do...
			}
			cameraCmdLength = parsebuf[1];
			
			//i=1 because of first length packet.
			for (int i=0; i<cameraCmdLength; i++)
            { 	comTest->writeByte(parsebuf[i+2]);
			}
			comTest->writeByte('\r'); // needed at end of camera cmds
			returnCamResponse();			
}



// this simple function reads a camera response and sends it back,
// or sends back an explanation that a timeout occured (in english, gasp)
void returnCamResponse()
{
	bool flag=false;
	char buf[100];
	int i=2;
	int timeout=0;
	int status=0;
	
	char responsePacket[200];
		
	while(true) {
		if(!comTest->readByte(buf[i])) { // readByte is NONBlocking! //
			timeout++;
			Sleep(50);
			if(timeout==CAMERATIMEOUT) {
				responsePacket[0] = 10;
				responsePacket[1] = 0;
				sendPacket(responsePacket, 2, tcpsocket);
				break;
			}
			if (i > 96) {
				responsePacket[0] = 10;
				responsePacket[1] = 0;
				sendPacket(responsePacket, 2, tcpsocket);
				break;				
			}
		} else { // there is a byte to read!
			if (buf[i] == ':') {
				buf[0] = 0;
				buf[1] = i-1;
				sendPacket(buf, i+1, tcpsocket);
				break;
			} else i++;
		} // end else	
	} // end while {}	
} // returnCamResponse() //


void RoverDeal(char* parsebuf, int parsecount)
{
	char camPan, camTilt, dir, vel, timeout;
	char mask;
	
	if (camCom == 1) { // switch to Rover
		//tcpsocket->sendData("Switching router to rover comm");
		switchRoverCom(); camCom = 0;
		Sleep(10);
		comTest->EmptyInputBuffer();
		// we need to deal with rover reset and buffer flush here
	}

	// set current time
	GetSystemTime(&systime);
	
	mask = parsebuf[6];
	camTilt = parsebuf[5];
	camPan = parsebuf[4];
	dir = parsebuf[3];
	vel = parsebuf[2];
	if (mask & 1) { // set timeout of robot //
		timeout = parsebuf[1];
		pidTimeout = (int)timeout;
	}
	if (mask & 64) { // init robot //
		initRobot(); // turns all servoes off, full range, PID off, PID params set
		PIDoff = true; headOn = false; neckOn = false; motorOn = false;
	}

	if (mask & 32) { // kill motors! //
		killMotor();
		Sleep(10);
		PIDoff = true;
	}
	if (mask & 2) { // vel set
		
		pidLastSec=justSecs(systime.wMinute,systime.wSecond);
		motorLastSec=justSecs(systime.wMinute,systime.wSecond);
		// dont time out the steering servo as long as you are driving the dc motor!
		
		if (PIDoff) {
			bool checkPID=turnPIDon(); // turns PID control on again
			if (checkPID) PIDoff = false; 
			else PIDoff = true;
		}

		setVel(vel);
	}
	if (mask & 4) { // set steering direction
		
		motorLastSec=justSecs(systime.wMinute,systime.wSecond);
		if(!motorOn) {

			bool checkMotor = initServo(MOTOR);
			if(checkMotor) motorOn =true;
			else motorOn=false;
		}	
		setServo(dir, MOTOR);
	}
	if ((mask & 8) && (!trackOn) && (!tracknt)) { // set pan, but only if not in track mode!
		
		neckLastSec=justSecs(systime.wMinute,systime.wSecond);
		if(!neckOn) {
			
			bool checkNeck = initServo(NECK);
			if(checkNeck) neckOn =true;
			else neckOn=false;
		
		}	
		setServo(camPan, NECK);
		trackCP = camPan;
	}
	if ((mask & 16) && (!trackOn) && (!tracknp)) { // set tilt, but only if not in track mode!
		
		headLastSec=justSecs(systime.wMinute,systime.wSecond);
		if(!headOn) {
			bool checkHead = initServo(HEAD);
			if(checkHead) headOn =true;
			else headOn=false;
		
		}	
		
		setServo(camTilt, HEAD);
		trackCT = camTilt;
	}

	// call a function that reads from the rover and creates return packet //
	returnRoverResponse();

} // RoverDeal() //

// returns total in seconds 
int justSecs(int minutes, int secs) {
	return ((60 * minutes)+secs);
} // justSecs() //

// return Rover packet to computer. 0 at beginning if no error; 20 if there is
// a problem getting info from the Rover
void returnRoverResponse()
{
	char response[50];
	char pwm[4], range;
	bool success = true;

	if (getPWM(pwm)) {
		if (get_rangeRead(range)) {
			response[0]=0;		//status byte
			response[1]= range;	//range reading
			response[2]= pwm[0];//EMF high byte
			response[3]= pwm[1];//EMF low byte
			response[4]= pwm[2];//PWM high byte
			response[5]= pwm[3];//PWM low byte
			response[6]=0;		//X High Byte
			response[7]=0;		//X Low Byte
			response[8]=0;      //Y High Byte
			response[9]=0;		//Y Low Byte
			response[10]=0;      //Theta High Byte
			response[11]=0;      //Theta Low Byte
			
			sendPacket(response, 12, tcpsocket);
			return;
		} // if (get..
	} // if (getPWM..
	
	// this is the timeout case. Set router back to camera mode so it is re-switched next time
	camCom = 1;
	response[0]=20;		//status byte
	response[1]=0;  //range reading
	response[2]=0;
	response[3]=0;
	response[4]=0;			
	response[5]=0;      //same as before
	response[6]=0;
	response[7]=0;
	response[8]=0;
	response[9]=0;
	response[10]=0;
	response[11]=0;

	sendPacket(response, 12, tcpsocket);

} // returnRoverResponse() //

// sending a pure raw command from java straight to the brainstem //
void StemDeal(char* parsebuf)
{
		int stemCmdLength;

		// BrainStem command. send it!
			if (camCom == 1) {
				switchRoverCom(); camCom = 0;
			}
			comTest->EmptyInputBuffer(); // for safety and slowness, always do...

			stemCmdLength = parsebuf[1];
			
			for (int i=0; i<stemCmdLength; i++)
            { 	comTest->writeByte(parsebuf[i+2]);
			}
			//comTest->writeByte('\r'); // needed at end of camera cmds
			returnStemResponse();			
}

void returnStemResponse()
{
	bool flag=false;
	char buf[100];
	int i=2;
	int timeout=0;
	int status=0;
			
	while(true) {
		if(!comTest->readByte(buf[i])) { // readByte is NONBlocking! //
			timeout++;
			Sleep(50);
			if(timeout==STEMTIMEOUT) { // we wait 300 ms total //
				buf[0] = 0;
				buf[1] = i-1;
				sendPacket(buf, i+1, tcpsocket);
				break;
			}
			
		}//end if 
		else { // there is a byte to read!
			i++;
		} // end else	
	} // end while {}	
} // returnStemResponse () //



// dump frame sends data on 5001 but *beforehand* sends status on 5000
void DumpFrameDeal()
{
	char theBuffer[34646];
	int i=0;
	bool seen3=false;
	int timeout=0;
	bool done=false;
	bool timedout = false;

	// stop the motor (kill motor) //
	if (camCom == 1) { // switch to Rover
		//tcpsocket->sendData("Switching router to rover comm");
		switchRoverCom(); camCom = 0;
		// we need to deal with rover reset and buffer flush here
	}
	killMotor();
	PIDoff = true;

	// switch to the camera and prepare for dump frame
	if (camCom == 0) {
		switchCamCom(); switchCamCom();camCom = 1;
		comTest->writeByte('\r');
		Sleep(100); // a waste of time, but safe for now //
		comTest->EmptyInputBuffer();
	}

	char response[2];
	response[0]=0;
	sendPacket(response,1, tcpsocket);
	
	// send the "df\r" command
	comTest->writeByte('d');
	comTest->writeByte('f');
	comTest->writeByte('\r'); // needed at end of camera cmds

	while(!done && timeout< 500) {
		if(!comTest->readByte(theBuffer[i])) {
			timeout++;
			if(timeout==500) {
				done=true; timedout = true;
			}
			Sleep(1);
		} else {
			if(seen3 && theBuffer[i]==':') {
				done=true; timedout = false;
				//MessageBox(0,TEXT("Valid DumpFrame!"),TEXT("Dump"),MB_OK);
			} 
			if(theBuffer[i]==3) {
				seen3=true;
			}
			timeout=0;
			i++;
			if (i > 34645) {
				done = true;
				timedout = true;
			}
		}
	}
	
	// we have either timed out or have a whole frame ready.
	// if we got a whole frame, send on port 5001
	if (done && !timedout) {
		
		int iter;
		for (iter=0; iter < i/2000; iter++) {
			dfsocket->sendData2(&(theBuffer[iter*2000]), 2000);
			Sleep(250);			
		}
		dfsocket->sendData2(&(theBuffer[iter*2000]), i%2000);
	} 
	else {
		//do not send anything... //
		//MessageBox(0,TEXT("INVALID DumpFrame!"),TEXT("Dump"),MB_OK);
	} 
	
	
} // DumpFrameDeal()


void colourTrack(char *parsebuf)
{

	char response[1],buf[12];
	response[0]=0;
	sendPacket(response,1, tcpsocket);
	unsigned char r = parsebuf[1];
	unsigned char R = parsebuf[2];
	unsigned char g = parsebuf[3];
	unsigned char G = parsebuf[4];
	unsigned char b = parsebuf[5];
	unsigned char B = parsebuf[6];

	
	// switch to camera on router if necessary //
	if (camCom == 0) 
	{
		switchCamCom(); switchCamCom();camCom = 1;
		comTest->writeByte('\r');
		Sleep(50); // a waste of time, but safe for now // // timeout less Illah 6/14
		comTest->EmptyInputBuffer();
	}
	
	
	// now send "tc\r"

	int count=sprintf(buf," %d %d %d %d %d %d",r,R,g,G,b,B);
	if(count<12) MessageBox(0,TEXT("spf not sending all data"),TEXT(""),MB_OK);
	comTest->writeByte('t');
	comTest->writeByte('c');
	for(int i=0;buf[i]!=0;i++)
		comTest->writeByte(buf[i]);
	
	comTest->writeByte('\r'); // needed at end of camera cmds

	trackCP = cmdCP; trackCT = cmdCT;
	//trackOn = true; 
	trackState = 0; // trackState is for parsing CMUcam return string //

	
} //colourtrack()



void windowTrack()
{
	char response[1];
	response[0]=0;
	sendPacket(response,1, tcpsocket);

	// switch to camera on router if necessary //
	if (camCom == 0) {
		switchCamCom(); switchCamCom();camCom = 1;
		comTest->writeByte('\r');
		Sleep(50); // a waste of time, but safe for now // // timeout less Illah 6/14
		comTest->EmptyInputBuffer();
	}
	// now send "tw\r"
	comTest->writeByte('t');
	comTest->writeByte('w');
	comTest->writeByte('\r'); // needed at end of camera cmds
	trackCP = cmdCP; trackCT = cmdCT;
	//trackOn = true; 
	trackState = 0; // trackState is for parsing CMUcam return string //

	
} // windowTrack() //


void stopTrack()
{
	char response[1];
	response[0]=0;
	trackOn = false;
	tracknp	= false;
	tracknt = false;
	tracknpnt = false;
	// stop CMUcam stream //
	comTest->writeByte('\r');
	Sleep(50); 
	comTest->EmptyInputBuffer();
	// eventually check for ACK from camera here //
	sendPacket(response,1, tcpsocket);
}


void handleTimeouts()
{		
			int curSecs;
			//GET CURRENT TIME
			GetSystemTime(&systime);
			curSecs = justSecs(systime.wMinute, systime.wSecond);

			//test each servo and pid for alive signs
			if ((neckOn) && ((curSecs - neckLastSec) > neckTimeout) && !trackOn) {
				// deal with switching RoverCom //
				if (camCom == 1) { // switch to Rover
					switchRoverCom(); switchRoverCom(); camCom = 0;
					comTest->EmptyInputBuffer();
				}
				killServo(NECK);
				neckOn = false;
			}

			if ((headOn) && ((curSecs - headLastSec) > headTimeout) && !trackOn) {
				// deal with switching RoverCom //
				if (camCom == 1) { // switch to Rover
					switchRoverCom(); switchRoverCom(); camCom = 0;
					//Sleep(20);
					comTest->EmptyInputBuffer();
				}
				killServo(HEAD);
				headOn = false;
			}


			if ((motorOn) && ((curSecs - motorLastSec) > motorTimeout) && (PIDoff) && !trackOn) {
				// deal with switching RoverCom //
				if (camCom == 1) { // switch to Rover
					switchRoverCom(); switchRoverCom(); camCom = 0;
					//Sleep(20);
					comTest->EmptyInputBuffer();
				}
				killServo(MOTOR);
				motorOn = false;
			}
			
			if (pidTimeout!=0 && (!PIDoff) && ((curSecs - pidLastSec) > pidTimeout)) {
				// deal with switching RoverCom //
				if (camCom == 1) { // switch to Rover
					switchRoverCom(); switchRoverCom(); camCom = 0;
					//Sleep(20);
					comTest->EmptyInputBuffer();
				}
				killMotor();
				PIDoff = true;
			}

} // handleTimeouts()



unsigned char checksum(char* sockData, int length)
{
    int csum=0;
    for(int i=0; i<length ;i++)
    {
        csum += sockData[i];
    }
    csum %= 256;

	return (unsigned char)csum;
}


/***************************************************************************************************/
/***************************************************************************************************/



/***************************************************************************************************/
/***************************************************************************************************/


//Sets all servos to full range of motion, kills motor 
// and sets the PID and period constants
void initRobot()
{
	for(int i=0;i<4;i++)
	{
		initServo(i);
		setServoRange(i);
		killServo(i);
		
	}
	setMotorConstants();
	killMotor();
}

void killRobot()
{
	killMotor();
	for(int i=0;i<4;i++)
		killServo(i);
		
}

//Enables a servo driver with default speed
bool initServo(int servoID)
{
	int speed = 137;//default servo speed of 7
		
	if(servoID==0) speed= 135; //Motor is heavy so less speed!
			
		char data,servo;
		int numTimeouts=0;

	   	COM->writeByte(2);  // module address
        COM->writeByte(3);  // length of packet
        COM->writeByte(31); //opcode
        COM->writeByte(servoID);  // servo id
        COM->writeByte(speed); //Servo driver now enabled with speed 7
		Sleep(10);	


		COM->writeByte(2);  // module address
        COM->writeByte(2);  // length of packet
        COM->writeByte(31); //opcode
        COM->writeByte(servoID);  // servo id
		
		for(int i=0; i<5; i++) {
			if (!COM->readByte(data)) {
				i--;
				numTimeouts++;
				if (numTimeouts == 10) { 
					//MessageBox(0,TEXT(" Servo on Timeout"),TEXT(""),MB_OK);
					return false; }
				Sleep(10);
			} 
			else {
				if(i == 4)  servo = data;
				} // end else
		} // end for

		// Servos on 
		if(servo) return true;
		else
		// Servos still off...init did not work
		
		{
			//MessageBox(0,TEXT("Servo not on!"),TEXT(""),MB_OK);
			return false;
		}
		
}//initServo()

//Sets an individual servo to full range of motion
void setServoRange(int servoID)
{
	 //packet cmdSRV_LMT
         COM->writeByte(2);   // module address
         COM->writeByte(4);   // length of packet
         COM->writeByte(32);  //opcode
         COM->writeByte(servoID);  // servo id
         COM->writeByte(0);   // Pos 0 Range
		 COM->writeByte(70);  // Pos  70 Range 
	   //packet cmdSRV_LMT
		Sleep(10);
}	

//Disables a servo driver and sets on-flag to OFF
void killServo(int servoID)
{
				
	   	COM->writeByte(2);  // module address
        COM->writeByte(3);  // length of packet
        COM->writeByte(31); //opcode
        COM->writeByte(servoID);  // servo id
        COM->writeByte(0); //Servo driver now disabled 
		Sleep(10);
		
		
}

//Command servo to go to absolute position
void setServo(char angle, int servoID)
{
		// set globals for last commanded head/neck servo positions
		if (servoID == NECK) cmdCP = angle;
		else if (servoID == HEAD) cmdCT = angle;

		COM->writeByte(2);  	// module address
        COM->writeByte(3);		// length of packet
        COM->writeByte(33);	//opcode
        COM->writeByte(servoID); // servo id
        COM->writeByte(angle);	// abs position
		Sleep(10);
}

//Set the motor control to PID with backemf 
bool turnPIDon()
{
	/* the original way to do it. Now we use new firmware method! 
		
		 COM->writeByte(4);		//address of moto board
		COM->writeByte(5);		// length
		COM->writeByte(63);		//opcode		
		COM->writeByte(1);		// motor channel	
		COM->writeByte(0);		// Parameter id
		COM->writeByte(6);		// Mode "A2D Vel Control"
		COM->writeByte(1);		// Lower Byte
		setVel(0); setVel(0);
	*/
		
		char data;
		char pid[2];
		int numTimeouts = 0;
		
		COM->writeByte(4);
		COM->writeByte(7);
		COM->writeByte(63);
		COM->writeByte(1);
		COM->writeByte(0);
		COM->writeByte(6);
		COM->writeByte(1);
		COM->writeByte(0xFE);
		COM->writeByte(0x0C);
	
		Sleep(10);

		COM->writeByte(4);
		COM->writeByte(3);
		COM->writeByte(63);
		COM->writeByte(1);
		COM->writeByte(0);
		
		Sleep(20);
		
		for (int i=0; i<7; i++) {
			if (!COM->readByte(data)) {
				i--;
				numTimeouts++;
				if (numTimeouts == 10) { 
		//			MessageBox(0,TEXT("CheckPID on Timeout"),TEXT(""),MB_OK);
					return false; }
				Sleep(10);
			} 
			else {
				if (i == 5)  pid[0] = data;
				else if (i == 6) pid[1] = data;
			} // end else
		} // end for

		//Motor is on in PID mode
		if((pid[0]==6) && (pid[1]==1)) return true;
		// Motor is still off...init did not work
		else
		{
		//	MessageBox(0,TEXT("CheckPID got response, PID not on!"),TEXT(""),MB_OK);
			return false;
		}
}


//Set the motor speed to a specified value between -200 to -800 
void setVel(char speed)
{
	
	int intSpeed;
	intSpeed = (int)speed;
	intSpeed = intSpeed * (600.0 / 256.0);
	intSpeed = intSpeed - 500;

		//breaking the speed into High and Low bytes for the Stem to understand
	unsigned char hbyte = (intSpeed >> 8);
	unsigned char lbyte = (unsigned char)(intSpeed & 255);
	
		
		COM->writeByte(4);		//address of moto board
		COM->writeByte(4);		// length
		COM->writeByte(62);		//opcode		
		COM->writeByte(1);		// motor channel	
		COM->writeByte(hbyte);	// Higher speed byte
		COM->writeByte(lbyte);	// Lower speed byte
		Sleep(10);
}

// returns T if got the PWM parameters successfully, 
//If timeout returns false
bool getPWM(char* pwm)
{
		char data;
		int numTimeouts = 0;
		comTest->EmptyInputBuffer();
		COM->writeByte(4);		//address of moto board
		COM->writeByte(2);		// length
		COM->writeByte(61);		//opcode		
		COM->writeByte(1);		// motor channel
		
		for (int i=0; i<10; i++) {
			if (!COM->readByte(data)) {
				i--;
				numTimeouts++;
				if (numTimeouts == 10) { return false; }
				Sleep(10);
			} else {
				if (i == 4)  pwm[0] = data;
				else if (i == 5) pwm[1] = data;
				else if (i == 8) pwm[2] = data;
				else if (i == 9) pwm[3] = data;
			} // end else
		} // end for
		// if we get here, we've got everything!
		return true;
} 

//Set PID and period and Latency each time 
void setMotorConstants()
{

	COM->writeByte(4);		//address of moto board
	COM->writeByte(5);		// length
	COM->writeByte(63);		//opcode		
	COM->writeByte(1);		// motor channel	
	COM->writeByte(1);		// Proportional Constant
	COM->writeByte(0);		// Higher Byte
	COM->writeByte(20);		// Lower Byte
	Sleep(20);

	COM->writeByte(4);		//address of moto board
	COM->writeByte(5);		// length
	COM->writeByte(63);		//opcode		
	COM->writeByte(1);		// motor channel	
	COM->writeByte(2);		// Integral Constant
	COM->writeByte(0);		// Higher Byte
	COM->writeByte(0);		// Lower Byte
	Sleep(20);

	COM->writeByte(4);		//address of moto board
	COM->writeByte(5);		// length
	COM->writeByte(63);		//opcode		
	COM->writeByte(1);		// motor channel	
	COM->writeByte(3);		// Derivative Constant
	COM->writeByte(0);		// Higher Byte
	COM->writeByte(80);		// Lower Byte
	Sleep(20);

	COM->writeByte(4);		//address of moto board
	COM->writeByte(5);		// length
	COM->writeByte(63);		//opcode		
	COM->writeByte(1);		// motor channel	
	COM->writeByte(6);		// Period
	COM->writeByte(0);		// Higher Byte
	COM->writeByte(100);	// Lower Byte
	Sleep(20);

	COM->writeByte(4);		//address of moto board
	COM->writeByte(5);		// length
	COM->writeByte(63);		//opcode		
	COM->writeByte(1);		// motor channel	
	COM->writeByte(7);		// Latency
	COM->writeByte(0);		// Higher Byte
	COM->writeByte(5);		// Lower Byte
	Sleep(20);


}

	
//Stop sending anything to the motor. Shut down. 
void killMotor()

{
		COM->writeByte(4);		//address of moto board
		COM->writeByte(5);		// length
		COM->writeByte(63);	//opcode		
		COM->writeByte(1);		// motor channel	
		COM->writeByte(0);		// Parameter id
		COM->writeByte(0);		// Mode "OFF"
		COM->writeByte(0);		// Lower Byte
		Sleep(10);
}

//Gets the rangefinder reading and returns true if valid.
//If timeout returns false.
bool get_rangeRead(char & range)
{
	char data;
	int numTimeouts = 0;
	comTest->EmptyInputBuffer();
	ask_rangeRead();
	for (int i=0; i<5; i++) {
		if (!COM->readByte(data)) {
			i--;
			if (numTimeouts == 10) { return false; }
			Sleep(10);
			numTimeouts++;
		} else {
			// we read a byte.increment i (for loop does this for you). //
			;
		} // end else
	} // end for
	range = data;
	return true;
} // get_rangeRead() //


//Command to tell the Stem to give us the range reading.
void ask_rangeRead()

{
	//packet cmdIR02_RD
                COM->writeByte(2);		// module address
                COM->writeByte(2);		// length of packet
                COM->writeByte(30);	//opcode
                COM->writeByte(128);	// give value back to Host
    //packet cmdIR02_RD
}


/***************************************************************************************************/
/***************************************************************************************************/







///////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ROVERCOM));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND	hWnd = NULL;
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
	LoadString(hInstance, IDC_ROVERCOM, szWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);

	//If it is already running, then focus on the window
	hWnd = FindWindow(szWindowClass, szTitle);	
	if (hWnd) 
	{
		SetForegroundWindow ((HWND) (((DWORD)hWnd) | 0x01));    
		return 0;
	} 

	MyRegisterClass(hInstance, szWindowClass);
	
	RECT	rect;
	GetClientRect(hWnd, &rect);
	
	hWnd = CreateWindow(szWindowClass, szTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hWnd)
	{	
		return FALSE;
	}
	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it
	// if a menubar is present
	{
		RECT rc;
		GetWindowRect(hWnd, &rc);
		rc.bottom -= MENU_HEIGHT;
		if (hwndCB)
			MoveWindow(hWnd, rc.left, rc.top, rc.right, rc.bottom, FALSE);
	}


	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HDC hdc;
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	TCHAR szHello[MAX_LOADSTRING];

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
				case IDM_EXIT:
					shutdown(false);
				    DestroyWindow(hWnd);
					break;
				case IDM_FOLLOW:
					startFollow();
					break;
				case IDM_STOPFOLLOW:
					stop_follow();
					send_vel(0,NothingProcess);
					break;
				case IDM_START:
					start_comm();
					break;
				case IDM_HELP_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				    break;
				case IDOK:
					SendMessage(hWnd, WM_ACTIVATE, MAKEWPARAM(WA_INACTIVE, 0), (LPARAM)hWnd);
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CreateRpCommandBar(hWnd);
			break;
		case WM_PAINT:
			RECT rt;
			hdc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rt);
			LoadString(hInst, IDS_VERSION, szHello, MAX_LOADSTRING);
			DrawText(hdc, szHello, _tcslen(szHello), &rt, 
				DT_SINGLELINE | DT_VCENTER | DT_CENTER);
			EndPaint(hWnd, &ps);
			break; 
		case WM_DESTROY:
			CommandBar_Destroy(hwndCB);
			PostQuitMessage(0);
			break;
		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai);
     		break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	SHMENUBARINFO mbi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi)) 
		return NULL;

	return mbi.hwndMB;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;

	switch (message)
	{
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			shidi.dwMask = SHIDIM_FLAGS;
			 shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
			return TRUE; 

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK) {
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////


